//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Reflection;
using System.Reflection.Emit;

namespace Emit
{
	/// <summary>
	/// Podsumowanie dla EmitMain.
	/// </summary>
	class EmitMain
	{
		static Type GenerateCode()
		{
			AppDomain currentDomain = AppDomain.CurrentDomain;

			// Utworzenie nowego podzespou w AppDomain
			AssemblyName assemblyName = new AssemblyName();
			assemblyName.Name = "HelloAssembly";
			// Utworzenie AssemblyBuilder
			AssemblyBuilder assemblyBuilder = currentDomain.DefineDynamicAssembly(assemblyName, AssemblyBuilderAccess.Run);
			// Utworzenie ModuleBuilder
			ModuleBuilder moduleBuilder = assemblyBuilder.DefineDynamicModule("HelloModule");
			// Utworzenie TypeBuilder
			TypeBuilder typeBuilder = moduleBuilder.DefineType("HelloClass", TypeAttributes.Public);
			// Utworzenie MethodBuilder
			MethodBuilder methodBuilder = typeBuilder.DefineMethod("HelloWorld", MethodAttributes.Public, null, null);
			// Utworzenie generatora MSIL
			ILGenerator msil = methodBuilder.GetILGenerator();
			// Wygenerowanie kodu
			msil.EmitWriteLine("Witajwiecie!");
			msil.Emit(OpCodes.Ret);
			// Zwrcenie utworzonego typu
			return typeBuilder.CreateType();
		}
		static void Main(string[] args)
		{
			try
			{
				Type t = GenerateCode();
				object o = Activator.CreateInstance(t);
				MethodInfo mi = t.GetMethod("HelloWorld");
				Console.WriteLine(mi.Invoke(o, null));
			}
			catch(Exception e)
			{
				Console.WriteLine(e);
			}
		}
	}
}
